/*  
 * Copyright (C) 2005 Martin Pischky (mailto:martin@pischky.de)  
 *
 * This file (HexDump.java) is part of IntelHexFile.
 *
 * IntelHexFile is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 */

/*
 * $Log: HexDump.java,v $
 * Revision 1.1  2005/03/27 12:29:58  pischky
 * added
 *
 */

package org.fremo.ihx.demo;

import java.io.FileReader;
import java.io.IOException;

import org.fremo.ihx.HexFileReader;
import org.fremo.ihx.InvalidHexFileException;
import org.fremo.ihx.Memory;

/**
 * @author martin
 *
 * Dump a intel hex file 
 * arg[0] is the filename
 */
public class HexDump {

    private String filename;

    public HexDump(String filename) {
        super();
        this.filename = filename;
    }
    
    public void dump() 
    throws InvalidHexFileException, IOException 
    {
        FileReader fr = new FileReader(filename);
        HexFileReader hfr = new HexFileReader(fr);
        Memory mem = hfr.read();
        hfr.close();
        fr.close();
        System.out.print( mem );
    }
    
    public static void main(String[] args) {
        if( args.length < 1 ) {
            System.out.println("usage: HexDump <filename>");
            return;
        }
        try {
            HexDump hd = new HexDump(args[0]);
            hd.dump();
        } catch (InvalidHexFileException e) {
            System.err.println("invalid hexfile");
            System.err.println(e.getMessage());
        } catch (IOException e) {
            System.err.println("io error");
            System.err.println(e.getMessage());
        }
    }

}
